/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.additions.common.AdditionsLang;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.api.text.EnumColor;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemWalkieTalkie
extends Item
implements IModeItem {
    public ItemWalkieTalkie(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add(BooleanStateDisplay.OnOff.of((boolean)this.getOn(stack), (boolean)true).getTextComponent());
        tooltip.add((Component)AdditionsLang.CHANNEL.translateColored(EnumColor.DARK_AQUA, new Object[]{EnumColor.GRAY, this.getChannel(stack)}));
        if (!MekanismAdditionsConfig.additions.voiceServerEnabled.get()) {
            tooltip.add((Component)AdditionsLang.WALKIE_DISABLED.translateColored(EnumColor.DARK_RED, new Object[0]));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.setOn(itemStack, !this.getOn(itemStack));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41746_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void setOn(ItemStack itemStack, boolean on) {
        ItemDataUtils.setBoolean((ItemStack)itemStack, (String)"running", (boolean)on);
    }

    public boolean getOn(ItemStack itemStack) {
        return ItemDataUtils.getBoolean((ItemStack)itemStack, (String)"running");
    }

    public void setChannel(ItemStack itemStack, int channel) {
        ItemDataUtils.setInt((ItemStack)itemStack, (String)"channel", (int)channel);
    }

    public int getChannel(ItemStack itemStack) {
        int channel = ItemDataUtils.getInt((ItemStack)itemStack, (String)"channel");
        if (channel == 0) {
            this.setChannel(itemStack, 1);
            channel = 1;
        }
        return channel;
    }

    public void changeMode(@Nonnull Player player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        int newChannel;
        int channel;
        if (this.getOn(stack) && (channel = this.getChannel(stack)) != (newChannel = Math.floorMod(channel + shift - 1, 8) + 1)) {
            this.setChannel(stack, newChannel);
            if (displayChangeMessage) {
                player.m_6352_(MekanismUtils.logFormat((Object)AdditionsLang.CHANNEL_CHANGE.translate(new Object[]{newChannel})), Util.f_137441_);
            }
        }
    }

    @Nonnull
    public Component getScrollTextComponent(@Nonnull ItemStack stack) {
        return AdditionsLang.CHANNEL.translateColored(EnumColor.GRAY, new Object[]{this.getChannel(stack)});
    }
}

